<!DOCTYPE html>
<html lang="en">
    <head>
        <script src="https://cdn.tailwindcss.com?plugins=forms,typography"></script>
        <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&amp;display=swap" rel="stylesheet"/>
        <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet"/>
        <script>
            tailwind.config = {
                darkMode: "class",
                theme: {
                extend: {
                    colors: {
                    primary: "#3b82f6", // blue-500
                    "background-light": "#f1f5f9", // slate-100
                    "background-dark": "#0f172a", // slate-900
                    },
                    fontFamily: {
                    display: ["Roboto", "sans-serif"],
                    },
                    borderRadius: {
                    DEFAULT: "0.375rem", // md
                    },
                },
                },
            };
            </script>
        <style>
            .material-icons {
                font-size: 1.25rem;
                line-height: 1;
                vertical-align: middle;
            }
        </style>
    </head>

    <body class="font-display bg-background-light dark:bg-background-dark text-slate-800 dark:text-slate-300">
        <div class="flex h-screen">
            
            <main class="flex-1 flex flex-col">
                

                <div class="flex-1 overflow-y-auto p-6">
                    <div class="bg-white dark:bg-slate-800 p-6 rounded-lg shadow-sm">
                        <div class="flex items-center space-x-2 mb-6 pb-6 border-b border-slate-200 dark:border-slate-700">
                            <button class="flex items-center space-x-2 bg-slate-100 dark:bg-slate-700 hover:bg-slate-200 dark:hover:bg-slate-600 text-slate-700 dark:text-slate-200 px-4 py-2 rounded-md transition-colors">
                                <span class="material-icons">add_circle_outline</span>
                                <span>New</span>
                            </button>

                            <button class="flex items-center space-x-2 bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded-md transition-colors">
                                <span class="material-icons">save</span>
                                <span>Save</span>
                            </button>

                            <button class="flex items-center space-x-2 bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md transition-colors">
                                <span class="material-icons">search</span>
                                <span>Search</span>
                            </button>

                            <button class="flex items-center space-x-2 bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-md transition-colors">
                                <span class="material-icons">cancel</span>
                                <span>Cancel</span>
                            </button>
                        </div>

                        <div class="grid grid-cols-12 gap-x-6 gap-y-4">
                        <div class="col-span-12 lg:col-span-7 space-y-4">
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-x-6 gap-y-4">
                        <div class="col-span-1">
                        <label class="block text-sm font-medium text-slate-600 dark:text-slate-400 mb-1" for="invoice-no">Invoice No</label>
                        <div class="flex">
                        <input class="flex-grow bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-l-md text-sm p-2 focus:ring-primary focus:border-primary" id="invoice-no" placeholder="Ref No" type="text"/>
                        <button class="bg-primary hover:bg-blue-600 text-white px-4 rounded-r-md text-sm">Find</button>
                        </div>
                        </div>
                        <div class="col-span-1">
                        <label class="block text-sm font-medium text-slate-600 dark:text-slate-400 mb-1" for="pay-type">Pay Type</label>
                        <select class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" id="pay-type">
                        <option>CREDIT</option>
                        <option>CASH</option>
                        </select>
                        </div>
                        </div>
                        <div>
                        <label class="block text-sm font-medium text-slate-600 dark:text-slate-400 mb-1" for="customer">Customer</label>
                        <div class="flex">
                        <input class="flex-grow bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-l-md text-sm p-2 focus:ring-primary focus:border-primary" id="customer" type="text"/>
                        <button class="bg-primary hover:bg-blue-600 text-white px-4 rounded-r-md text-sm">Find</button>
                        <button class="bg-orange-400 hover:bg-orange-500 text-white px-4 rounded-md text-sm ml-2">New</button>
                        </div>
                        </div>
                        <div>
                        <label class="block text-sm font-medium text-slate-600 dark:text-slate-400 mb-1" for="address">Address</label>
                        <input class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" id="address" type="text"/>
                        </div>
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-x-6 gap-y-4">
                        <div class="col-span-1">
                        <label class="block text-sm font-medium text-slate-600 dark:text-slate-400 mb-1" for="tel">Tel</label>
                        <input class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" id="tel" type="tel"/>
                        </div>
                        <div class="col-span-1">
                        <label class="block text-sm font-medium text-slate-600 dark:text-slate-400 mb-1" for="labour">Labour</label>
                        <select class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" id="labour">
                        <option value=""></option>
                        </select>
                        </div>
                        </div>
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-x-6 gap-y-4">
                        <div class="col-span-1">
                        <label class="block text-sm font-medium text-slate-600 dark:text-slate-400 mb-1" for="department">Department</label>
                        <select class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" id="department">
                        <option>OFFICE-01</option>
                        </select>
                        </div>
                        <div class="col-span-1">
                        <label class="block text-sm font-medium text-slate-600 dark:text-slate-400 mb-1" for="sales-ex">Sales Ex</label>
                        <select class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" id="sales-ex">
                        <option>01 Office</option>
                        </select>
                        </div>
                        </div>
                        </div>
                        <div class="col-span-12 lg:col-span-5 space-y-4">
                        <div class="flex space-x-2 mb-2">
                        <span class="bg-cyan-500 text-white text-xs font-semibold px-3 py-1.5 rounded-full flex items-center">
                        <span class="w-2 h-2 rounded-full bg-white mr-2"></span>CASH
                                                        </span>
                        <span class="bg-cyan-500 text-white text-xs font-semibold px-3 py-1.5 rounded-full flex items-center">
                        <span class="w-2 h-2 rounded-full bg-white mr-2"></span>CREDIT
                                                        </span>
                        </div>
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-x-6 gap-y-4">
                        <div>
                        <label class="block text-sm font-medium text-slate-600 dark:text-slate-400 mb-1" for="company">Company</label>
                        <select class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" id="company">
                        <option>NORMAL</option>
                        </select>
                        </div>
                        <div>
                        <label class="block text-sm font-medium text-slate-600 dark:text-slate-400 mb-1" for="date">Date</label>
                        <input class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" id="date" type="text" value="12/04/2025"/>
                        </div>
                        </div>
                        <div class="bg-slate-100 dark:bg-slate-700/50 p-4 rounded-lg">
                        <div class="grid grid-cols-5 text-center text-sm font-medium text-slate-600 dark:text-slate-400">
                        <div>SO Status</div>
                        <div>Rtn Chq</div>
                        <div>Over 60</div>
                        <div>Credit Bal</div>
                        <div>Over Pay</div>
                        </div>
                        <div class="grid grid-cols-5 gap-2 mt-2">
                        <input class="bg-white dark:bg-slate-600 border border-slate-300 dark:border-slate-500 rounded text-sm p-1.5 w-full text-center" type="text"/>
                        <input class="bg-white dark:bg-slate-600 border border-slate-300 dark:border-slate-500 rounded text-sm p-1.5 w-full text-center" type="text"/>
                        <input class="bg-white dark:bg-slate-600 border border-slate-300 dark:border-slate-500 rounded text-sm p-1.5 w-full text-center" type="text"/>
                        <input class="bg-white dark:bg-slate-600 border border-slate-300 dark:border-slate-500 rounded text-sm p-1.5 w-full text-center" type="text"/>
                        <input class="bg-white dark:bg-slate-600 border border-slate-300 dark:border-slate-500 rounded text-sm p-1.5 w-full text-center" type="text"/>
                        </div>
                        <div class="flex items-center justify-end mt-4">
                        <span class="bg-cyan-500 text-white text-xs font-semibold px-3 py-1.5 rounded-full flex items-center">
                        <span class="w-2 h-2 rounded-full bg-white mr-2 ring-1 ring-cyan-500"></span>Non VAT
                                                            </span>
                        </div>
                        </div>
                        </div>
                        </div>
                    </div>

                    <div class="mt-6 bg-white dark:bg-slate-800 p-6 rounded-lg shadow-sm">
                    <div class="flex border-b border-slate-200 dark:border-slate-700 mb-4">
                    <button class="px-4 py-2 text-sm font-medium border-b-2 border-primary text-primary">PRODUCT</button>
                    <button class="px-4 py-2 text-sm font-medium text-slate-500 dark:text-slate-400 hover:text-slate-700 dark:hover:text-slate-200">DAG</button>
                    <button class="px-4 py-2 text-sm font-medium text-slate-500 dark:text-slate-400 hover:text-slate-700 dark:hover:text-slate-200">PURCHASE</button>
                    </div>
                    <div class="overflow-x-auto">
                    <table class="w-full text-sm text-left">
                    <thead class="bg-slate-50 dark:bg-slate-700/50 text-slate-600 dark:text-slate-400 uppercase text-xs">
                    <tr>
                    <th class="p-3">Item Code</th>
                    <th class="p-3">Description</th>
                    <th class="p-3">Serial No</th>
                    <th class="p-3">Price</th>
                    <th class="p-3">Qty</th>
                    <th class="p-3">Dis1 (%)</th>
                    <th class="p-3">Dis2 (%)</th>
                    <th class="p-3">Unit Total</th>
                    <th class="p-3 text-center">#</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr class="border-b border-slate-200 dark:border-slate-700">
                    <td class="p-2"><input class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" type="text"/></td>
                    <td class="p-2 w-1/4">
                    <div class="flex items-center">
                    <button class="bg-primary hover:bg-blue-600 text-white px-3 py-2 rounded-l-md text-sm">View</button>
                    <input class="w-full bg-slate-50 dark:bg-slate-700 border-t border-b border-r border-slate-300 dark:border-slate-600 rounded-r-md text-sm p-2 focus:ring-primary focus:border-primary" type="text"/>
                    </div>
                    </td>
                    <td class="p-2"><input class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" type="text"/></td>
                    <td class="p-2"><input class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" type="text"/></td>
                    <td class="p-2"><input class="w-20 bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" type="text"/></td>
                    <td class="p-2"><input class="w-20 bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" type="text"/></td>
                    <td class="p-2"><input class="w-20 bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" type="text"/></td>
                    <td class="p-2"><input class="w-full bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" type="text"/></td>
                    <td class="p-2 text-center"><button class="bg-primary hover:bg-blue-600 text-white px-4 py-2 rounded-md text-sm w-full">Add</button></td>
                    </tr>
                    </tbody>
                    </table>
                    </div>
                    <div class="flex justify-between items-start mt-6 pt-6 border-t border-slate-200 dark:border-slate-700">
                    <div>
                    <label class="block text-sm font-medium text-slate-600 dark:text-slate-400 mb-1" for="stock-level">Stock Level</label>
                    <input class="w-24 bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 focus:ring-primary focus:border-primary" id="stock-level" type="text"/>
                    </div>
                    <div class="space-y-3 w-1/4">
                    <div class="flex items-center">
                    <label class="w-28 text-right mr-4 text-sm font-medium text-slate-600 dark:text-slate-400" for="sub-total">Sub Total</label>
                    <input class="flex-grow bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 text-right focus:ring-primary focus:border-primary" id="sub-total" type="text"/>
                    </div>
                    <div class="flex items-center">
                    <label class="w-28 text-right mr-4 text-sm font-bold text-slate-700 dark:text-slate-200" for="grand-total">Grand Total</label>
                    <input class="flex-grow bg-slate-50 dark:bg-slate-700 border border-slate-300 dark:border-slate-600 rounded-md text-sm p-2 text-right font-bold focus:ring-primary focus:border-primary" id="grand-total" type="text"/>
                    </div>
                    </div>
                    </div>
                    </div>
                </div>
            </main>
        </div>

    </body>
</html>